
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    //matq    z, zInv, I, x;
    bf      det;
    int     i, j, k, nr, nc;
    double  p;
    int     m, numMats;
    matq    *z, t, table;
    
again:
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    //cin.ignore();  // needed for next cin with prompt to behave
    
    m = 0;
    while(m<1)
    {
        cout << "m: ";
        cin >> m;
    }
    cout << "k = " << pow(p, m)-1 << endl << endl;
    genMatrixGroup(z, numMats, m, p);
    
    for(k=0;k<numMats;++k)
    {
        cout << "a^" << k << " =" << endl;
        t = z[k];
        for (i=0;i<t.nr;++i)
            for(j=0;j<t.nc;++j)
            {
                if(j<t.nc-1)
                    cout << t.array[i][j] << "  ";
                else
                    cout << t.array[i][j] << "\n";
            }
        cout << endl;
    }
    
    
    if(isGroupField(table, z, numMats, p))
    {
        cout << "addition table:" << endl;
        for(i=0;i<numMats;++i)
            for(j=0;j<numMats;++j)
            {
                if(j<numMats-1)
                    cout << table.array[i][j] << "  ";
                else
                    cout << table.array[i][j] << "\n";
            }
        cout << endl;
    }
    else
        cout << "not a field" << endl;
    
    goto again;
    
    return 0;
}
 /*
 clock_t start, end;
 double elapsed;
 
 start = clock();

end = clock();
elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
 */
